<?php
/**
 * Default header builder settings
 *
 * @package xts
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$header_settings = array(
	'overlap'          => array(
		'id'          => 'overlap',
		'title'       => 'همپوشانی هدر',
		'type'        => 'switcher',
		'tab'         => 'General',
		'value'       => false,
		'description' => 'هدر روی محتوا می افتد',
	),

	'boxed'            => array(
		'id'          => 'boxed',
		'title'       => 'جعبه ای',
		'type'        => 'switcher',
		'tab'         => 'General',
		'value'       => false,
		'description' => 'هدر به جای عرض کامل ، جعبه ای می شود',
		'requires'    => array(
			'overlap' => array(
				'comparison' => 'equal',
				'value'      => true,
			),
		),
	),

	'background_hover' => array(
		'id'          => 'background_hover',
		'title'       => esc_html__( 'Background on hover', 'xts-theme' ),
		'description' => esc_html__( 'Overlap header with transparent background will have a white background on mouse over.', 'xts-theme' ),
		'type'        => 'switcher',
		'tab'         => 'General',
		'value'       => false,
		'requires'    => array(
			'overlap' => array(
				'comparison' => 'equal',
				'value'      => true,
			),
		),
	),

	'full_width'       => array(
		'id'          => 'full_width',
		'title'       => 'محتوای کشیده',
		'description' => esc_html__( 'Make the header content wider then your website container.', 'xts-theme' ),
		'type'        => 'switcher',
		'tab'         => 'General',
		'value'       => false,
	),

	'sticky_effect'    => array(
		'id'          => 'sticky_effect',
		'title'       => 'افکت هدرچسبیده',
		'type'        => 'selector',
		'tab'         => 'Sticky header',
		'value'       => 'stick',
		'options'     => array(
			'stick' => array(
				'value' => 'stick',
				'label' => 'هدرچسبیده با اسکرول',
			),
			'slide' => array(
				'value' => 'slide',
				'label' => 'بعد اسکرول به پایین هدرچسبیده شود',
			),
		),
		'description' => 'شما میتونید از 2 افکت موجود انتخاب کنید',
	),

	'sticky_clone'     => array(
		'id'          => 'sticky_clone',
		'title'       => 'عناصر مهم در هدرچسبیده',
		'type'        => 'switcher',
		'tab'         => 'Sticky header',
		'value'       => false,
		'requires'    => array(
			'sticky_effect' => array(
				'comparison' => 'equal',
				'value'      => 'slide',
			),
		),
		'description' => 'عناصر مهم هدر چسبنده (لوگو، منو، جستجو و ویجت سبد خرید) را در یک خط نشان می دهد',
	),

	'sticky_height'    => array(
		'id'          => 'sticky_height',
		'title'       => 'ارتفاع هدر چسبنده',
		'type'        => 'slider',
		'tab'         => 'Sticky header',
		'from'        => 0,
		'to'          => 200,
		'value'       => 50,
		'units'       => 'px',
		'description' => 'ارتفاع هدر چسبنده بر حسب پیکسل تعیین کنید',
		'requires'    => array(
			'sticky_clone'  => array(
				'comparison' => 'equal',
				'value'      => true,
			),
			'sticky_effect' => array(
				'comparison' => 'equal',
				'value'      => 'slide',
			),
		),
	),

	'sticky_shadow'    => array(
		'id'          => 'sticky_shadow',
		'title'       => 'سایه به هدر چسبنده',
		'type'        => 'switcher',
		'tab'         => 'Sticky header',
		'value'       => true,
		'description' => 'هنگامی که هدر چسبیده است، یک سایه اضافه کنید',
	),

	'hide_on_scroll'   => array(
		'id'          => 'hide_on_scroll',
		'title'       => esc_html__( 'Hide when scrolling down', 'xts-theme' ),
		'description' => esc_html__( 'Hides the sticky header when you scroll the page down. And shows only when you scroll top.', 'xts-theme' ),
		'type'        => 'switcher',
		'tab'         => 'Sticky header',
		'value'       => false,
	),
);

return apply_filters( 'xts_default_header_settings', $header_settings );
